package agentes;


import jade.content.lang.Codec;
import jade.content.lang.sl.*;
import policiaOntology.*;
import jade.content.onto.Ontology;
import jade.content.*;
import jade.content.onto.basic.*;


import jade.core.Agent;
import jade.core.behaviours.*;
import jade.domain.FIPANames;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;


public class EjemploAgente extends Agent {
	
	  Behaviour comp; //Atributo para almacenar el comportamiento
	  private Codec codec;
	  private Ontology ontologia;
	
	 protected void setup() {
		 
		 codec = new SLCodec();
		 ontologia = PolicicaOntology.getInstance();
		  
		// Registra el lenguaje de contenido y la ontologia utilizada
	    getContentManager().registerLanguage(codec);
	    getContentManager().registerOntology(ontologia);

		    
		 //Cumpliendo las especificaciones FIPA, cada agente posee un Identificador de Agente 
		 //(objeto de la clase jade.core.AID), que va a tener la siguiente estructura: 
		 //
		 
		// getName() -> obtiene el nombre completo del agente (GUID) y devuelve un string (ej.: AP@Plataforma)
	    // getAID() -> nombre_agente@host:puerto/JADE

		   System.out.println("El agente "+ getAID().getName() +" se ha iniciado.");
		   
		 //Podemos registrar un comportamiento en el setup()
		    comp= new MiComportamiento1();
	        addBehaviour(comp);
	        

	    }
	 
	 protected void takeDown() { //aqu se definen las operaciones de limpieza
	        System.out.println("El agente "+getAID().getName()+" ha sido finalizado.");
	        removeBehaviour(comp);//Borramos el primer comportamiento;
	    }
	
	 
	 
	 //Este es el comportamiento.
	    private class MiComportamiento1 extends Behaviour{
	    	
	    	//action(): Este mtodo ejecuta el comportamiento
	        public void action(){
	        System.out.println("Mi nombre es: "+getName() );
	            System.out.println("Soy el comportamiento del agente");
	 
	    }
	        
	        //done(): Comprueba si el mtodo ha concluido
	        public boolean done(){
	            return true; //Si devolvemos false indicamos que no ha concluido el comportamiento
	        }
	    }

	
}
